/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.gradle;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.json.JSONArray;
import org.json.JSONObject;

class Visitor {
    private JSONObject tree = new JSONObject();

    public void outputJson() {
        this.log(this.tree.toString(2));
    }

    public void visit(List<ASTNode> list) {
        this.tree.put("type", (Object)"root");
        JSONArray jSONArray = new JSONArray();
        this.tree.put("children", (Object)jSONArray);
        for (ASTNode aSTNode : list) {
            if (!(aSTNode instanceof BlockStatement)) continue;
            jSONArray.put((Object)this.visitBlockStatement((BlockStatement)aSTNode));
        }
    }

    private JSONObject visitBlockStatement(BlockStatement blockStatement) {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        for (Statement statement : blockStatement.getStatements()) {
            JSONObject jSONObject2;
            if (!(statement instanceof ExpressionStatement) || (jSONObject2 = this.visitExpressionStatement((ExpressionStatement)statement)) == null) continue;
            jSONArray.put((Object)jSONObject2);
        }
        jSONObject.put("type", (Object)"block");
        this.addSourceInfo((ASTNode)blockStatement, jSONObject);
        jSONObject.put("children", (Object)jSONArray);
        return jSONObject;
    }

    private JSONObject visitExpressionStatement(ExpressionStatement expressionStatement) {
        Expression expression = expressionStatement.getExpression();
        if (expression instanceof MethodCallExpression) {
            MethodCallExpression methodCallExpression = (MethodCallExpression)expression;
            return this.visitMethodCallExpression(expressionStatement, methodCallExpression);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            return this.visitBinaryExpression(expressionStatement, binaryExpression);
        }
        return null;
    }

    private JSONObject visitBinaryExpression(ExpressionStatement expressionStatement, BinaryExpression binaryExpression) {
        Expression expression = binaryExpression.getLeftExpression();
        Expression expression2 = binaryExpression.getRightExpression();
        if (expression instanceof VariableExpression && expression2 instanceof ConstantExpression) {
            VariableExpression variableExpression = (VariableExpression)expression;
            ConstantExpression constantExpression = (ConstantExpression)expression2;
            String string = variableExpression.getName();
            String string2 = constantExpression.getText();
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("type", (Object)"variable");
            jSONObject.put("name", (Object)string);
            jSONObject.put("value", constantExpression.getValue());
            jSONObject.put("children", (Object)new JSONArray());
            this.addSourceInfo((ASTNode)binaryExpression, jSONObject);
            return jSONObject;
        }
        return null;
    }

    private JSONObject visitMethodCallExpression(ExpressionStatement expressionStatement, MethodCallExpression methodCallExpression) {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        this.addSourceInfo((ASTNode)expressionStatement, jSONObject);
        ConstantExpression constantExpression = (ConstantExpression)methodCallExpression.getMethod();
        String string = (String)constantExpression.getValue();
        TupleExpression tupleExpression = (TupleExpression)methodCallExpression.getArguments();
        List list = tupleExpression.getExpressions();
        for (Expression expression : list) {
            if (!(expression instanceof ClosureExpression)) continue;
            jSONArray.put((Object)this.visitClosureExpression((ClosureExpression)expression));
        }
        jSONObject.put("children", (Object)jSONArray);
        jSONObject.put("type", (Object)"method");
        jSONObject.put("name", (Object)string);
        return jSONObject;
    }

    private JSONObject visitClosureExpression(ClosureExpression closureExpression) {
        JSONObject jSONObject = new JSONObject();
        Statement statement = closureExpression.getCode();
        if (statement instanceof BlockStatement) {
            return this.visitBlockStatement((BlockStatement)statement);
        }
        return jSONObject;
    }

    private JSONObject visitExpression(Expression expression) {
        return new JSONObject();
    }

    private void addSourceInfo(ASTNode aSTNode, JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("line", aSTNode.getLineNumber());
        jSONObject2.put("column", aSTNode.getColumnNumber());
        jSONObject2.put("lastLine", aSTNode.getLastLineNumber());
        jSONObject2.put("lastColumn", aSTNode.getLastColumnNumber());
        jSONObject.put("source", (Object)jSONObject2);
    }

    private void log(String string) {
        System.out.println(string);
    }
}

