"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const log_1 = require("../../util/log");
async function execute(ctx, op) {
    var _a, _b;
    const xmlOp = op;
    const entries = xmlOp.value;
    for (const entry of entries) {
        let filename = entry.file;
        let xmlFile = null;
        if (entry.resFile) {
            filename = entry.resFile;
            xmlFile = (_a = ctx.project.android) === null || _a === void 0 ? void 0 : _a.getResourceXmlFile(filename);
        }
        else {
            xmlFile = (_b = ctx.project.android) === null || _b === void 0 ? void 0 : _b.getXmlFile(filename);
        }
        if (!xmlFile) {
            throw new Error(`No such XML file for xml operation: ${filename}`);
        }
        try {
            await xmlFile.load();
        }
        catch (e) {
            (0, log_1.error)('Unable to load the XML file here', e);
            return;
        }
        if (entry.attrs) {
            await xmlFile.setAttrs(entry.target, entry.attrs);
        }
        else if (entry.inject) {
            await xmlFile.injectFragment(entry.target, entry.inject);
        }
        else if (entry.merge) {
            await xmlFile.mergeFragment(entry.target, entry.merge);
        }
        else if (entry.replace) {
            await xmlFile.replaceFragment(entry.target, entry.replace);
        }
        else if (entry.delete) {
            await xmlFile.deleteNodes(entry.delete);
        }
        else if (entry.deleteAttributes) {
            await xmlFile.deleteAttributes(entry.target, entry.deleteAttributes);
        }
    }
}
exports.default = execute;
exports.OPS = [
    'android.xml'
];
//# sourceMappingURL=xml.js.map