"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const log_1 = require("../../util/log");
async function execute(ctx, op) {
    var _a;
    for (const key of Object.keys(op.value)) {
        let v = op.value[key];
        if (typeof v === 'boolean') {
            v = v ? 'YES' : 'NO';
        }
        try {
            (_a = ctx.project.ios) === null || _a === void 0 ? void 0 : _a.setBuildProperty(op.iosTarget, op.iosBuild, key, v);
        }
        catch (e) {
            log_1.logger.warn(`Skipping ${op.id} (${e.message})`);
        }
    }
}
exports.default = execute;
exports.OPS = [
    'ios.buildSettings'
];
//# sourceMappingURL=buildSettings.js.map