"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OPS = void 0;
const project_1 = require("@trapezedev/project");
async function execute(ctx, op) {
    var _a;
    const stringsOp = op;
    const entries = stringsOp.value;
    if (!ctx.project.ios) {
        return;
    }
    for (const entry of entries) {
        let filename = entry.file;
        let stringsFile = null;
        stringsFile = (_a = ctx.project.ios) === null || _a === void 0 ? void 0 : _a.getProjectFile(filename, (filename) => new project_1.StringsFile(filename, ctx.project.vfs, ctx.project));
        if (!stringsFile) {
            return;
        }
        await stringsFile.load();
        if (entry.set) {
            stringsFile.set(entry.set);
        }
        if (entry.setFromJson) {
            await stringsFile.setFromJson(entry.setFromJson);
        }
    }
}
exports.default = execute;
exports.OPS = [
    'ios.strings'
];
//# sourceMappingURL=strings.js.map