"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadProject = void 0;
const path_1 = require("path");
const project_1 = require("@trapezedev/project");
const utils_fs_1 = require("@ionic/utils-fs");
const log_1 = require("./util/log");
async function loadProject(args, projectRootPath, androidProject, iosProject) {
    const enableIos = (args.ios && args.android) || !args.android;
    const enableAndroid = (args.android && args.ios) || !args.ios;
    if (enableAndroid && androidProject && !(await (0, utils_fs_1.pathExists)((0, path_1.join)(projectRootPath !== null && projectRootPath !== void 0 ? projectRootPath : '', androidProject)))) {
        throw new Error(`Unable to find Android project at ${(0, path_1.join)(projectRootPath !== null && projectRootPath !== void 0 ? projectRootPath : '', androidProject)}`);
    }
    if (enableIos && iosProject && !(await (0, utils_fs_1.pathExists)((0, path_1.join)(projectRootPath !== null && projectRootPath !== void 0 ? projectRootPath : '', iosProject)))) {
        throw new Error(`Unable to find iOS project at ${(0, path_1.join)(projectRootPath !== null && projectRootPath !== void 0 ? projectRootPath : '', iosProject)}`);
    }
    const config = (await loadConfig(projectRootPath, androidProject, iosProject));
    config.enableAndroid = enableAndroid;
    config.enableIos = enableIos;
    const project = new project_1.MobileProject(projectRootPath !== null && projectRootPath !== void 0 ? projectRootPath : '', config);
    try {
        await project.load();
    }
    catch (e) {
        (0, log_1.error)('Unable to load projects. Ensure Android and iOS paths are correct');
        throw e;
    }
    return project;
}
exports.loadProject = loadProject;
async function loadConfig(projectRootPath, androidProject, iosProject) {
    return {
        android: {
            path: androidProject !== null && androidProject !== void 0 ? androidProject : 'android'
        },
        ios: {
            path: iosProject !== null && iosProject !== void 0 ? iosProject : 'ios/App'
        }
    };
}
//# sourceMappingURL=project.js.map